define([
    'backbone',
    'Layout',
    'Vent',
    'modules/new-appointment-request/views/direct/preferred-date/time-button',
], function(Backbone, Layout, radio, TimeButtonView) {
    'use strict';

    describe('Time Button View', function() {
        var view;
        var $view;
        var layout = new Layout();

        layout.render();

        radio.trigger = jasmine.createSpy('trigger');

        beforeEach(function() {
            view = new TimeButtonView({model: new Backbone.Model({startDateTime: '06/12/2016 14:30:00'})});

            layout.showChildView('content', view);
            $view = view.$el;
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        it('shows the start time', function () {
            expect($view.find('span:eq(1)').text()).toEqual('14:30');
        });

        it("triggers 'time-slot:selected' when clicked", function() {
            $view.click();
            expect(radio.trigger).toHaveBeenCalledWith('time-slot:selected', view, view.model);
        });
    });
});
